/*
 * This File is one of the examples from Java Object Oriented Programming
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */
package salesApplication;

/**
 *
 * @author Matthew Gregory
 */

import java.time.LocalDate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import products.Item;
import products.Notepad;
import products.TaxableItem;
import products.WritingImplement;

public interface CompanyInfo {
    final static String COMPANY_NAME = "Moving Stationery";
    final static String ABN = "11 222 333 444";//Australian Business Number.

    static String getNotice(){
        return "\u00A9 "+LocalDate.now().getYear()+" "+ COMPANY_NAME
            + "\nNo part of this price list may be reproduced digitally or physically "
            + "without the express permission of the company.";
    }
    
    final static String COPYRIGHT_NOTICE = getNotice();
    
    //Standard Company Discounts
    UnaryOperator<Item> clearanceSale = p->{p.setPrice(p.getPrice()*0.8);return p;};
    UnaryOperator<Item> halfPriceSale = p->{p.setPrice(p.getPrice()*0.5);return p;};

    //Standard Company Filters
    Predicate<Item> isWritingImplement = p->p instanceof WritingImplement;
    Predicate<Item> isNotepad = p->p instanceof Notepad;
    Predicate<Item> isTaxable = p->p instanceof TaxableItem;
    
    //Standard Price List Actions
    Consumer<Item> print = p->System.out.println(p);
    Consumer<Item> printTax = p->(new ManageTax()).printTaxInvoice(p);
}
